/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.util.PathHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;

public class TacPathVisitor
extends SimpleFileVisitor<Path> {
    private final File root;
    private final String namespace;
    private final String suffix;
    private final BiConsumer<class_2960, Path> consumer;

    public TacPathVisitor(File root, String namespace, String suffix, BiConsumer<class_2960, Path> consumer) {
        this.root = root;
        this.namespace = namespace;
        this.suffix = suffix;
        this.consumer = consumer;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (file.toFile().getName().endsWith(this.suffix)) {
            String path = PathHandler.getPath(this.root.toPath(), file, this.suffix);
            class_2960 id = new class_2960(TacPathVisitor.checkNamespace(this.namespace), path);
            this.consumer.accept(id, file);
        }
        return FileVisitResult.CONTINUE;
    }

    public static String checkNamespace(String namespace) {
        if (Objects.equals(namespace, "tacz-fabric")) {
            return "tacz";
        }
        return namespace;
    }
}

